#include <bits/stdc++.h>

using namespace std;

#define MAXN 1010

long long n,q;
vector<pair<pair<long long,long long>,string> > vec;
string seg1[MAXN*4];
long long seg2[MAXN*4];

void build1(long long node,long long l,long long r)
{
    if (l==r) seg1[node]=" ";
    else
    {
        long long mid=(l+r)/2;
        build1(2*node,l,mid);
        build1(2*node+1,mid+1,r);
        seg1[node]=seg1[2*node]+seg1[2*node+1];
    }
}

void update1(long long node,long long l,long long r,long long pos,string val)
{
    if (l==r) seg1[node]=val;
    else
    {
        long long mid=(l+r)/2;
        if (pos<=mid) update1(2*node,l,mid,pos,val);
        else update1(2*node+1,mid+1,r,pos,val);
        seg1[node]=seg1[2*node]+seg1[2*node+1];
    }
}

string query1(long long node,long long l,long long r,long long a,long long b)
{
    if (a>b) return "";
    if (l==a and r==b) return seg1[node];
    long long mid=(l+r)/2;
    return query1(2*node,l,mid,a,min(b,mid))+query1(2*node+1,mid+1,r,max(a,mid+1),b);
}


void build2(long long node,long long l,long long r)
{
    if (l==r) seg2[node]=0;
    else
    {
        long long mid=(l+r)/2;
        build2(2*node,l,mid);
        build2(2*node+1,mid+1,r);
        seg2[node]=seg2[2*node]+seg2[2*node+1];
    }
}

void update2(long long node,long long l,long long r,long long pos,long long val)
{
    if (l==r) seg2[node]=val;
    else
    {
        long long mid=(l+r)/2;
        if (pos<=mid) update2(2*node,l,mid,pos,val);
        else update2(2*node+1,mid+1,r,pos,val);
        seg2[node]=seg2[2*node]+seg2[2*node+1];
    }
}

long long query2(long long node,long long l,long long r,long long a,long long b)
{
    if (a>b) return 0;
    if (l==a and r==b) return seg2[node];
    long long mid=(l+r)/2;
    return query2(2*node,l,mid,a,min(b,mid))+query2(2*node+1,mid+1,r,max(a,mid+1),b);
}

int main()
{
    ios_base::sync_with_stdio(false);
    ios::sync_with_stdio(false);
    cin.tie(0);cout.tie(0);
    cin>>n>>q;
    for (long long i=1;i<=q;i++)
    {
        long long t;cin>>t;
        long long a,b;cin>>a>>b;
        string s;
        if (t==1) cin>>s;
        else s=" ";
        vec.push_back({{a,b},s});
    }
    build1(1,1,n-1);build2(1,1,n-1);
    for (long long i=0;i<q;i++)
    {
        long long a=vec[i].first.first;
        long long b=vec[i].first.second;
        string s=vec[i].second;
        if (s!=" ") {update1(1,1,n-1,a,s);update2(1,1,n-1,a,1);continue;}
        long long br=query2(1,1,n-1,a,b-1);
        if (br!=b-a) {cout<<0<<endl;continue;}
        string ss=query1(1,1,n-1,a,b-1);
        string t=ss;reverse(t.begin(),t.end());
        if (ss==t) cout<<1<<endl;
        else cout<<0<<endl;
    }
}